<?php
include 'constants.php';
include 'admin/portal.php';
include 'admin/mydb.php';

class PortalFront extends Portal
{
  public $zalogowany = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany = $this->getActualUser();
  }
  
  function getActualUser()
  {
    if(isset($_SESSION['zalogowany'])){
      return $_SESSION['zalogowany'];
    }
    else{
      return null;
    }
  }
  
  function setMessage($komunikat)
  {
    $_SESSION['komunikat'] = $komunikat;
  }
  
  function getMessage()
  {
    if(isset($_SESSION['komunikat'])){
      $komunikat = $_SESSION['komunikat'];
      unset($_SESSION['komunikat']);
      return $komunikat;
    }
    else {
      return null;
    }
  }

  function getRegUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
    
    $query = "SELECT COUNT(*) FROM Stats WHERE Data > "
           . "DATE_SUB(NOW(), INTERVAL $timeout MINUTE) "
           . "AND UserId <> 0";

    return $this->dbo->getQuerySingleResult($query);
  }
  
  function getAllUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
  
    $query = "SELECT COUNT(*) FROM Stats WHERE DATA > "
           . "DATE_SUB(NOW(), INTERVAL $timeout MINUTE)";
    
    return $this->dbo->getQuerySingleResult($query);
  }
  
  function getShortStats($timeout)
  {
    $regUsers = $this->getRegUsersOnline($timeout);
    $allUsers = $this->getAllUsersOnline($timeout);
    if($regUsers === false || $allUsers === false){
      return false;
    }
    else{
      return array(
        'timeout' => $timeout,
        'regUsers' => $regUsers,
        'allUsers' => $allUsers,
      );
    }
  }
  
  function getFullStats()
  {
    if(!$this->dbo) return "Statystki nie s dostpne.";
  
    //Weryfikacja danych
    $ile = -1;
    if(isset($_GET['ile'])){
      $ile = (int) $_GET['ile'];
      if($ile >= -1){
        if($ile == 0){
          //Czy zostay przekazane daty?
          if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
            //Czy daty odpowiadaj formatowi?
            if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
               !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
              //Niezgodno formatu.
              $ile = -1;
            }
            else{
              //Odczytanie dat.
              $dataOd = $_GET['dataOd'];
              $dataDo = $_GET['dataDo'];
            }
          }
          //Brak dat przy zaznaczonej opcji zakresu.
          else{
            $ile = -1;
          }
        }
        else{
          //Ustalenie maksymalnej dopuszczzalnej liczby dni.
          if($ile > 3660) $ile = 3660;
        }
      }
      //Parametr ile by nieprawidowy.
      else{
       $ile = -1;
      } 
    }
    
    //Formowanie warunkw zapyta i nagwka tabeli.
    if($ile == 0){
      //Dodanie warunku dotyczcego dat.
      $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
      $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
    }
    else if($ile > 0){
      //Dodanie warunku dotyczcego wybranego okresu.
      $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
      $statsInfo = "Statystyki z ostatnich $ile dni.";
    }
    else{
      //Dodanie pustego warunku.
      $cond = ' WHERE 1=1 ';
      $statsInfo = "Pene statystyki";
    }
    
    //Pobieranie liczby odwiedzin.
    $query = "SELECT COUNT(*) AS Ile FROM Stats ";
    $allVisits = $this->dbo->getQuerySingleResult(
      $query . $cond );
    $regVisits = $this->dbo->getQuerySingleResult(
      $query . $cond . 'AND UserId <> 0 ');
    $allVisits = (int) $allVisits;
    $regVisits = (int) $regVisits;
    $guestVisits = $allVisits - $regVisits;
    
    //Pobieranie statystyk przegldarek.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Przegladarki ";
    $query .= $cond;
    $query .= " AND Stats.BrowserId = Przegladarki.Id ";
    $query .= "GROUP BY BrowserId ORDER BY Ile DESC";
    
    $browsersInfo = $this->dbo->getQueryResultAsTableRows($query);

    //Pobieranie statystyk systemw.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Systemy ";
    $query .= $cond;
    $query .= " AND Stats.SystemId = Systemy.Id ";
    $query .= "GROUP BY SystemId ORDER BY Ile DESC";

    $systemsInfo = $this->dbo->getQueryResultAsTableRows($query);
    
    //Najczciej logujcy si uytkownicy.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Users ";
    $query .= $cond;
    $query .= " AND Stats.UserId = Users.Id AND Users.Id <> 0 ";
    $query .= "GROUP BY UserId ORDER BY Ile DESC LIMIT 10";

    $activeUsers = $this->dbo->getQueryResultAsTableRows($query);
    
    //Najczciej wystpujce adresy IP.
    $query = "SELECT inet_ntoa(IP) AS IP, COUNT(*) AS Ile FROM Stats ";
    $query .= $cond;
    $query .= "GROUP BY Ip ORDER BY Ile DESC LIMIT 10";
    
    $ips = $this->dbo->getQueryResultAsTableRows($query);
    
    //Adresy IP i daty ostatnich 10 pocze.
    $query = "SELECT inet_ntoa(IP) AS IP, Data FROM Stats ";
    $query .= $cond;
    $query .= "ORDER BY Data DESC LIMIT 10";
    
    $lastips = $this->dbo->getQueryResultAsTableRows($query);
    
    include 'templates/statsTable.php';
    return $result;
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostay przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie dugoci przekazanych cigw.
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    //$userNameLength = strlen(utf8_decode($user));
    //$userPassLength = strlen(utf8_decode($pass));
    //lub
    $userNameLength = mb_strlen($user, 'utf8');
    $userPassLength = mb_strlen($pass, 'utf8');
    
    if($userNameLength < 3 || $userNameLength > 20 ||
     $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znakw specjalnych w parametrach.
    $user = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzajcego poprawno danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystpi bd: nieprawidowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wynikw zapytania.
    if($result->num_rows <> 1){
      //Brak uytkownika o wskazanej nazwie lub zbyt wiele wynikw.
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania hase.
      if($pass != $pass_db){
      //Wersja z kodowaniem hase.
      //if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany'] = $row[1];
        if(isset($_SESSION['statRecordId']) && 
                ($_SESSION['statRecordId'] > 0)){
          $this->updateStatRecord($_SESSION['statRecordId'], $row[2]);
        }
        else{
          $_SESSION['statRecordId'] = $this->addStatRecord($row[2]);
        }
        return LOGIN_OK;
      }
    }
  }
  function logout()
  {
    if(isset($_SESSION['zalogowany'])){
      $this->zalogowany = null;
      unset($_SESSION['zalogowany']);
      $_SESSION['statRecordId'] = -1;
      /*
      //Jeli sesja ma by usunita:
      unset($_SESSION['statRecordId']);
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function addStatRecord($userId)
  {
    if(!$this->dbo) return 0;
    
    $browser = get_browser();
  
    //Pobranie identyfikatora przegldarki (jeli istnieje)
    $browserName = $this->dbo->real_escape_string($browser->browser);
    $query = "SELECT id FROM Przegladarki WHERE Nazwa='$browserName'";
    
    if(($browserId = $this->dbo->getQuerySingleResult($query)) === false){
      //Jezeli nie ma przegldarki w bazie, dodanie nowego wpisu.
      $query = "INSERT INTO Przegladarki VALUES(NULL,'$browserName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu
      $browserId = $this->dbo->insert_id;
    }
    
    //Pobranie identyfikatora systemu (jeli istnieje)
    $systemName = $this->dbo->real_escape_string($browser->platform);
    $query = "SELECT id FROM Systemy WHERE Nazwa = '$systemName'";
    
    if(($systemId = $this->dbo->getQuerySingleResult($query)) === false){
      //Jezeli nie ma systemu w bazie, dodanie nowego wpisu
      $query = "INSERT INTO Systemy VALUES(NULL, '$systemName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu
      $systemId = $this->dbo->insert_id;
    }
    
    if(!$systemId || !$browserId) return 0;
        
    //Dodanie nowego wpisu do tabeli Stats
    $ip = $_SERVER['REMOTE_ADDR'];$ip = '127.0.0.1';
    $query = "INSERT INTO Stats VALUES(" .
             "NULL, inet_aton('$ip'), NOW(), $systemId, $browserId, $userId)";

    //Jeeli wystpi bd przy dodawaniu wpisu dotyczcego przegldarki lub systemu
    if(!$this->dbo->query($query)){
      //echo 'Rekord statystyk nie zosta dodany.';
      return 0;
    }
    //Zwrcenie identyfikatora nowego wpisu
    return $this->dbo->insert_id;
  }
  
  function updateStatRecord($recordId, $userId)
  {
    if(!$this->dbo) return;
    
    $query = "UPDATE Stats SET UserId = $userId WHERE Id = $recordId";
    if(!$this->dbo->query($query)){
      //echo 'Nie udaa si aktualizaja statystyk.';
    }
  }
}
?>